// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _MOVE_H
#define _MOVE_H

class Move;

#include "board.h"
#include <iostream.h>

class Move
{
	// basic "move" class, minimizes storage.
	
	public:
	
	Move( const Square start, 
	      const Square dest,
	      const Piece::PieceType promotion = Piece::Invalid)
           : my_start(start),my_dest(dest),my_promotion(promotion)
        {
	}
	
	Move() :
           my_start(Square::InvalidSquare), 
	   my_dest(Square::InvalidSquare), my_promotion(Piece::Invalid)
	// constructs a null move
	{
        }
	
	static Move &NullMove();
	
	const int IsNull() const 
	{
	   return (my_start == Square::InvalidSquare);
	}
	
	const int operator == (const Move &m) const
	{
           return (my_start == m.my_start) && (my_dest == m.my_dest)
		   && (my_promotion == m.my_promotion);
	}
	
	const int operator != (const Move &m) const
	{
		return !(*this == m);
	}
		
	void MakeNull() 
	{
	   my_start = my_dest = Square::InvalidSquare;
	}
	
	const Square &StartSquare() const 
	{
	   return my_start;
	}
	
	const Square &DestSquare() const 
	{
	   return my_dest;
        }
	
	const Piece::PieceType PromoteTo() const
	{
	   return (Piece::PieceType)my_promotion;
	}
	
#ifdef _TRACE
	virtual const char *Image() const;
	// returns a human-readable string.  CAUTION: reuses
	// a static buffer for its return value
#endif
	
	static Move Value( char *str, const ColorType color );
	// parses "str", assuming it contains a move for side "color",
	// in the same string format returned by Image().  Returns
	// NullMove if the string cannot be parsed.
		
	//friend istream & operator >> (istream &i, Move &move);
#ifdef _TRACE
	friend ostream & operator << (ostream &o, Move &move);
#endif 
		
	protected:
		
        Square my_start;
	Square my_dest;
	//Piece::PieceType my_promotion;
        int16 my_promotion;
};

#endif

